** Do-fil til kapittel 5
** t-testen for to uavhengige utvalg
use "https://nedlasting.fagbokforlaget.no/stata/abu89.dta", clear
ttest time89, by(female) unequal  /* T-test, sigma ulik */
* effektstørrelse
esize twosample time89, by(female) cohensd hedgesg unequal
bootstrap r(d) r(g), reps(500) nowarn:  esize twosample time89, by(female)
** T-testen for parede utvalg
use "https://nedlasting.fagbokforlaget.no/stata/abu89_93.dta", clear
ttest time93 == time89  /* t-test for parede utvalg */
use "https://nedlasting.fagbokforlaget.no/stata/abu89.dta", clear
** enveis variansanalyse
oneway time89 klasse89, tabulate
oneway time89 klasse89, bonferroni /* Multiple sammenligninger Bonferroni */
*** Parvise sammenligninger
anova time89 klasse89
pwcompare klasse89, mcompare(bonferroni)
** Varianter av post hoc kontraster
contrast klasse89
contrast r.klasse89, nowald
contrast b3r.klasse89, nowald
contrast a.klasse89, nowald
* Planlagte kontraster
contrast {klasse89 1 -1 0 0 0} {klasse89 0 0 -2 1 1} 
* effektstørrelse
estat esize
estat esize, omega
** Oneway med en neste kontinuerlig faktor
anova time89 ed
margins ed
marginsplot
contrast p.ed  /* polynomiske kontraster */
*** Anova med interaksjon
anova time89 klasse89##female
margins, over(klasse89 female)
marginsplot   /* enkel versjon */
marginsplot, noci xdimension(klasse89, labels("Øvre service" "Nedre service" ///
 "Rutinefunksjonær" "Faglærte" "Ufaglærte"))


